function [ X ] = focuss_DSI( X0, y, A, lambda_, cg_iter, iter_lim, p, Xtrue, isCartesian )

% X0 : initial guess for pdf
% y : undersampled q-space data
% A : PDF_transform_reduced'  (observation matrix)
% lambda_ : regularization parameter
% cg_iter : no of conj grad iterations to use in CG_DSI
% iter_lim : no of outer Focuss iterations
% p : norm to impose on pdf  (p=1 for L1, p<1 for non-convex recon) 
% Xtrue : fully sampled, true pdf (to print RMSE)


if nargin < 4
    lambda_ = 0;
end

if nargin < 5
    cg_iter = 50;
end

if nargin < 6
    iter_lim = 10;
end

if nargin < 7
    p = 1;
end

if nargin < 8
    Xtrue = 0;
end

if nargin < 9
    isCartesian = 0;
end


L = size(y,4);  % number of voxels to reconstruct jointly
X = X0;


W = sqrt( sum(X.*conj(X),4) ) .^ (1-p/2);

row_size = round(sqrt(size(X,3)));
col_size = round(sqrt(size(X,3)));


k = 1;

while 1
  
%    disp(['-------- Iteration: ', num2str(k),' --------'])
     
    for m = 1:L
        
        if isCartesian
            q = CG_DSI( A, W, y(:,:,:,m), lambda_, cg_iter );
        else
            q = CG_DSI( A, W, y(:,m), lambda_, cg_iter );
        end
        X(:,:,:,m) = (W.*q);
        
    end
       

    
%     if Xtrue ~= 0
%         rmse_n = 100*norm( X(:)- Xtrue(:) ) / norm( Xtrue(:) );
%         rmse_str = (['Focuss RMSE: ', num2str(rmse_n), ' percent']);
%     else
%         rmse_str = [];
%     end
%     
%    tile_pdf(X(:,:,:,1),row_size,col_size,200,rmse_str);        
   
    
    W = sqrt( sum(X.*conj(X),4) ).^(1-p/2) ;
          

    if k >= iter_lim;        break;    end
      
    k = k+1; 
end


%disp('-------- End of reconstruction --------')

if Xtrue ~= 0
%    disp(['RMSE: ', num2str(100*norm(X(:)- Xtrue(:) ) / norm( Xtrue(:)) ), ' percent'])
end


end

