function [ X ] = focuss_DSI_dictonary( X0, y, A, Dksvd, lambda, cg_iter, iter_lim, p )

% X0 : initial guess for dictionary transform of pdf  
% y : undersampled q-space data
% A : DFT operator
% D : dictionary transform st pdf = Dksvd * gamma
% lambda : regularization parameter
% cg_iter : no of conj grad iterations to use in CG_DSI
% iter_lim : no of outer Focuss iterations
% p : norm to impose on pdf  (p=1 for L1, p<1 for non-convex recon) 


if nargin < 4
    lambda = 0;
end

if nargin < 5
    cg_iter = 50;
end

if nargin < 6
    iter_lim = 10;
end

if nargin < 7
    p = 1;
end


L = size(y,4);  % number of voxels to reconstruct jointly
X = X0;


W = sqrt( sum(X.*conj(X),2) ) .^ (1-p/2);

Dksvd_T = Dksvd';

k = 1;

while 1
       
    for m = 1:L      
        q = CG_DSI_dictionary( A, Dksvd, Dksvd_T, W, y(:,:,:,m), lambda, cg_iter );
        X(:,m) = W.*q;        
    end       
   
    W = sqrt( sum(X.*conj(X),2) ).^(1-p/2) ;     

    if k >= iter_lim;        break;    end
      
    k = k+1; 
end



end

