function res = FKernel(size_Xk,B0)

res.adjoint = 0;
res.B0 = B0;

zerosCube = zeros(size_Xk);
kx = zerosCube; ky = zerosCube; kz = zerosCube;

    
for count = 1:size_Xk(1)
    ky(count,:,:) = size_Xk(2)/2 - count + 1;
end

for count = 1:size_Xk(2)
    kx(:,count,:) = count - (size_Xk(1)/2 + 1);
end

for count = 1:size_Xk(3)
    kz(:,:,count) = count - (size_Xk(3)/2 + 1);
end


theta = 0;
k2 = kx.^2+ky.^2+kz.^2;
k2(k2==0) = eps;
res.kernel = 1/3 - (kz*cos(theta) - ky*sin(theta)).^2./k2;


DC = (kx==0) & (ky==0) & (kz==0);
res.kernel(DC==1) = 0;


res = class(res,'FKernel');

end
