%% load tissue field map

addpath('utils/')

load nfm_final_200iter
msk = nfm_final~=0;         % ROI mask


for t = 1:size(nfm_final,3)
    figure(1), imagesc( nfm_final(:,:,t), [-.04,.04]), axis image off, colormap gray, pause(.05)
end


%% pad the field map to 2x size, generate kernel

n = size(nfm_final);
msk_pad = padarray(msk, n/2);
nfm_pad = padarray(nfm_final, n/2);

N = size(nfm_pad);
FOV = N .* [240/256, 240/256, 2.5];  % (in milimeters)

D = fftshift(kspace_kernel(FOV, N));

for t = 20:size(nfm_pad,3)-20
    figure(1), imagesc( nfm_pad(:,:,t), [-.04,.04]), axis image off, colormap gray, pause(.02)
end


%% closed form QSM solution

[k2,k1,k3] = meshgrid(0:N(2)-1, 0:N(1)-1, 0:N(3)-1);
fdx = (1 - exp(-2*pi*1i*k1/N(1)));
fdy = (1 - exp(-2*pi*1i*k2/N(2)));
fdz = (1 - exp(-2*pi*1i*k3/N(3)));


lambda = .015;      % regularization parameter: chosen with L-curve heuristic

tic
    D_reg = D ./ ( eps + abs(D).^2 + lambda *( abs(fdx).^2 + abs(fdy).^2 + abs(fdz).^2 ) );
    D_regx = ifftn(D_reg .* fftn(nfm_pad));
toc


D_regx_crop = D_regx(1+n(1)/2:1.5*n(1), 1+n(2)/2:1.5*n(2), 1+n(3)/2:1.5*n(3)) .* msk;


for t = 1:size(D_regx_crop,3)
    figure(1), imagesc( real(D_regx_crop(:,:,t)), [-.2,.2]), axis image off, colormap gray, title('Susceptibility map'), pause(.1)
end



%% run iterative solution using nonlinear conjugate gradient

param = init;                   param.pNorm = 2;
param.TV = TVOP;                param.Itnlim = 10;
param.D = D;                    param.TVWeight = .015;  
param.data = nfm_pad;

chi_res = zeros(N);

tic
for h = 1:10
    chi_res = fnlCg_susc_padding_comparison(chi_res, param); 
end
toc

chi_res_crop = chi_res(1+n(1)/2:1.5*n(1), 1+n(2)/2:1.5*n(2), 1+n(3)/2:1.5*n(3)) .* msk;
    
for t = 1:size(chi_res_crop,3)
    figure(1), imagesc( real([chi_res_crop(:,:,t), D_regx_crop(:,:,t)]), [-.2,.2]), axis image off, colormap gray, title('Susceptibility map comparison'), pause(.1)
end


100 * norm(chi_res_crop(:) - D_regx_crop(:)) / norm(D_regx_crop(:))     % compute the RMSE between two solutions

